#include "preprocessing.h"
#include <iostream>

using namespace std;

int main(int argc, char *argv[]){

	Preprocessing p;
	vector<float> time;
	CvCapture * capture = NULL;
	

	if (argc>1) {
		capture = cvCaptureFromAVI(argv[1]);
	}
	else {
		capture = cvCaptureFromCAM(0);
	}

	if (!capture){
		cerr << "Could not initialize capture device" << endl;
		return -1;
	}

	TSMObject o;// ( 50, TSMObject::defaultSMName, true, 100);
	o.registerQueue("ORG_!");

	IplImage * image, * rimage = NULL;
	

	bool end = false;
	char c;
	int frameno = 0;

	while ((!end)&&(image = cvQueryFrame(capture))){
	
		rimage = cvCloneImage(image);
		p.addSourceFrame(rimage, "ORG", frameno);

		p.processSM();

		//
		c = cvWaitKey(2);
		p.showResults(); // ZDE ZOBRAZI REGISTROVANE FRONTY A JEJICH VYSTUPY
		end = (c=='x');

		frameno++;
		cout << "Frame " << frameno << "uploaded to SM"<< endl;
		//
	}
	if (capture) cvReleaseCapture(&capture);
	return 0;
}


//o.registerQueue("ORG_!_RESIZE_WIDTH_640_HEIGHT_480_!");
	//o.registerQueue("ORG_!_SKIP_FRAMES_0_!_CROP_TOP_200_LEFT_100_RIGHT_200_BOTTOM_300_!_RESIZE_WIDTH_320_HEIGHT_200_!");
	
	//o.registerQueue("ORG_!_CONVERT_FROM_RGB_TO_HSV_!_CONVERT_FROM_HSV_TO_RGB_!");
	//o.registerQueue("ORG_!_CONVERT_FROM_RGB_TO_GRAY_!");
	//o.registerQueue("ORG_!_CONVERT_FROM_RGB_TO_BGR_!");

	//o.registerQueue("ORG_CONVERT_FROM_RGB_TO_HSV)");
	//o.registerQueue("ORG_RESIZE_width_320_height_240)");
	//o.registerQueue("ORG_CROP_top_10_left_10_bottom_50_right_50)");
	//o.registerQueue("ORG_NSKIP_FRAMES_2");
